package com.example.sample.keycloak;
/* TODO パッケージを変更してご使用ください */

import org.jboss.logging.Logger;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;

import java.util.ArrayList;
import java.util.List;

public class DeviceIdTokenMapper extends AbstractOIDCProtocolMapper implements OIDCAccessTokenMapper, OIDCIDTokenMapper, UserInfoTokenMapper {

    public static final String PROVIDER_ID = "device-id-token-mapper";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<>();
    private static final Logger logger = Logger.getLogger(DeviceIdTokenMapper.class);

    static {
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, DeviceIdTokenMapper.class);
    }

    /**
     * アクセストークン作成時に呼び出される
     */
    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        // クライアントセッション（デバイス毎のセッション）からdevice_id を取得
        String deviceId = clientSessionCtx.getClientSession().getNote("device_id");
        // TODO 動作確認のため固定値を設定。本番稼働時は削除する
        if (deviceId == null) {
            deviceId = "sample-device-id";
        }
        logger.infof("device_id: %s", deviceId);
        OIDCAttributeMapperHelper.mapClaim(token, mappingModel, deviceId);
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getHelpText() {
        return "Adds device ID to the token.";
    }

    @Override
    public String getDisplayCategory() {
        return "Device ID token mapper";
    }

    @Override
    public String getDisplayType() {
        return "Device ID Token Mapper";
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }
}