package com.example.sample.keycloak;
/* TODO パッケージを変更してご使用ください */

import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel.Requirement;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

import java.util.List;

import static org.keycloak.models.AuthenticationExecutionModel.Requirement.REQUIRED;

public class DeviceIdAuthenticatorFactory implements AuthenticatorFactory {

    public static final String PROVIDER_ID = "device-id-authenticator";

    @Override
    public Authenticator create(KeycloakSession session) {
        return new DeviceIdAuthenticator();
    }

    @Override
    public void init(Config.Scope config) {
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public void close() {
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String getDisplayType() {
        return "Device ID Capture Authenticator";
    }

    @Override
    public String getReferenceCategory() {
        return "";
    }

    @Override
    public String getHelpText() {
        return "Captures device_id from authorization request and stores it in the session";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public Requirement[] getRequirementChoices() {
        return new Requirement[]{REQUIRED};
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }
}
