package com.example.sample.keycloak;
/* TODO パッケージを変更してご使用ください */

import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class DeviceIdAuthenticator implements Authenticator {

    private static final Logger logger = Logger.getLogger(DeviceIdAuthenticator.class);

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        // パラメータからdevice_id を取得
        String deviceId = context.getHttpRequest().getUri().getQueryParameters().getFirst("device_id");

        if (deviceId != null && !deviceId.isBlank()) {
            // クライアントセッション（デバイス毎のセッション）にdevice_id を保存
            logger.debugf("Device ID captured in authenticator: %s", deviceId);
            context.getAuthenticationSession().setClientNote("device_id", deviceId);
            context.success();
        } else {
            // 取得できなければエラーとして認証処理を中断させる
            logger.warn("Missing device_id parameter in authentication request");
            context.failure(AuthenticationFlowError.INVALID_CREDENTIALS);
        }
    }

    @Override
    public void action(AuthenticationFlowContext context) {
    }

    @Override
    public boolean requiresUser() {
        return false;
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    @Override
    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }
}
